import { NextResponse } from "next/server";

import type { NextRequest } from "next/server";
import { DEFAULT_AUTHENTICATED_REDIRECT_URL, DEFAULT_UNAUTHENTICATED_REDIRECT_URL, DEFAULT_UNAUTHORIZED_REDIRECT_URL } from "./config/site";
import { getIsUserAuthenticatedFromServer, getIsUserAuthorizedFromServer } from "./features/auth/lib/session.amplify";

export async function middleware(request: NextRequest) {
  const response = NextResponse.next();

  const authenticated = await getIsUserAuthenticatedFromServer()
  if (!authenticated) {
    return NextResponse.redirect(new URL(DEFAULT_UNAUTHENTICATED_REDIRECT_URL, request.url));
  }

  const authorized = await getIsUserAuthorizedFromServer("ADMIN")
  if (request.nextUrl.pathname !== '/unauthorized' && !authorized) {
    return NextResponse.redirect(new URL(DEFAULT_UNAUTHORIZED_REDIRECT_URL, request.url));
  }

  if (request.nextUrl.pathname === '/unauthorized' && authorized) {
    return NextResponse.redirect(new URL(DEFAULT_AUTHENTICATED_REDIRECT_URL, request.url));
  }

  return response;
}

export const config = {
  matcher: [
    /*
     * Match all request paths except for the ones starting with:
     * - api (API routes)
     * - _next/static (static files)
     * - _next/image (image optimization files)
     * - favicon.ico (favicon file)
     * - login
     */
    "/((?!api|_next/static|_next/image|favicon.ico|login).*)",
  ],
};
